<?php
namespace Saltus\WP\Plugin\Saltus\InteractiveGlobes\Services\Model\Pro;

/**
 * common meta
 */
class MetaRotate {
	public static function merge( $meta ) {

		// PRO rotate feature
		$meta['globe_info']['sections']['globe']['fields']['rotate'] = array(
			'type'   => 'fieldset',
			/* translators: legend refers to a caption or visual element explaining colours on map */
			'title'  => __( 'Auto Rotate', 'interactive-globes' ),
			'desc'   => __( 'Rotate animation', 'interactive-globes' ),
			'fields' => [
				'enabled' => [
					'type'   => 'switcher',
					/* translators: legend refers to a caption or visual element explaining colours on map */
					'title'  => __( 'Auto Rotate', 'interactive-globes' ),
					'desc'   => __( 'Rotate animation', 'interactive-globes' ),
					'default' => false,
				],
				'speed' => [
					'type'       => 'spinner',
					'default'    => 1.5,
					'step'       => 0.1,
					'title'      => __( 'Speed', 'interactive-globes' ),
					'dependency' => [ [ 'enabled', '==', true ] ],
				]
			],
		);

		return $meta;
	}
}
