<?php
namespace Saltus\WP\Plugin\Saltus\InteractiveGlobes\Services\Model\Pro;

/**
 * common meta
 */
class MetaLayers {
	public static function merge( $meta ) {

		// PRO tooltip meta
		$meta['globe_info']['sections']['layers'] = array(
			'title'  => __( 'Data Layers & Filters', 'interactive-globes' ),
			'icon'   => 'fa fa-layer-group fa-lg',
			'class'  => 'tooltip_tab',
			'fields' => array(
				'layersInfo'   => array(
					'type'    => 'content',
					'content' => '<div class="ig_admin_example"><div>' . __( 'Load data from other globes.', 'interactive-globes' ).'</div></div>',
				),
                'layer'          => [
					'title'      => __( 'Select Globes', 'interactive-globes' ),
					'subtitle'   => __( 'Select globes you want to load data from.<br>You can sort the options using drag&drop to change their order.', 'interactive-globes' ),
					'type'       => 'checkbox',
					'options'    => 'posts',
					'query_args' => [
						'posts_per_page' => -1,
						// 'order'          => 'ASC',
						// 'orderby'        => 'title',
						'post_type'      => 'iglobe',
						'post__not_in'   => [ isset( $_GET['post'] ) && null !== $_GET['post'] && ! is_array( $_GET['post'] ) ? sanitize_key( $_GET['post'] ) : '' ],
					],
				],
				'layerOrder'     => [
					'type'       => 'textarea',
					'default'    => '',
					'class'      => 'hidden',
					'attributes' => [
						'class' => 'hidden',
					],
				],
				'liveFilter'       => [
					'type'   => 'fieldset',
					'title'  => __( 'Live Filter', 'interactive-globes' ),
					'subtitle'   => __( 'Display a live filter to show/hide data in the globe.', 'interactive-globes' ),
					'fields' => [
						'enabled'  => [
							'type'    => 'switcher',
							'title'   => __( 'Enable', 'interactive-globes' ),
							'default' => false,
						],
						'type' => [
							'type'       => 'select',
							'title'      => __( 'Type', 'interactive-globes' ),
							'default'    => 'menu',
							'dependency' => [ 'enabled', '==', true ],
							'options'    => [
								'menu' => __( 'Filter Menu', 'interactive-globes' ),
								'dropdown' => __( 'Dropdown Filter', 'interactive-globes' ),
								'menu_dropdown' => __( 'Filter Menu & Dropdown on Mobile', 'interactive-globes' ),
								'toggle' => __( 'Toggle Menu', 'interactive-globes' ),
							],
						],
						'position' => [
							'type'       => 'select',
							'title'      => __( 'Position', 'interactive-globes' ),
							'default'    => 'above',
							'dependency' => [ 'enabled', '==', true ],
							'options'    => [
								'above' => __( 'Above', 'interactive-globes' ),
								'below' => __( 'Below', 'interactive-globes' ),
							],
						],
						'allLabel' => [
							'type'       => 'text',
							'title'      => __( 'Label for "All"', 'interactive-globes' ),
							'default'    => 'All',
							'desc'       => __( 'Leave blank if you don\'t want the option to display.', 'interactive-globes' ),
							'dependency' => [ ['enabled', '==', true], ['type', '!=', 'toggle'] ],
						],
						'default'  => [
							'title'      => __( 'Display by default', 'interactive-globes' ),
							'desc'       => __( 'Display the data from this globe by default and hide all the others. Select the current globe if you want all to display by default.', 'interactive-globes' ),
							'type'       => 'select',
							'options'    => 'posts',
							'dependency' => [ 'enabled', '==', true ],
							'default'    => [ isset( $_GET['post'] ) && null !== $_GET['post'] && ! is_array( $_GET['post'] ) ? sanitize_key( $_GET['post'] ) : '' ],
							'query_args' => [
								'posts_per_page' => -1,
								'post_type'      => 'iglobe',
							],
						],
						'keepBase'  => [
							'type'    => 'switcher',
							'title'   => __( 'Keep Base Map', 'interactive-globes' ),
							'desc'    => __( 'Set the data from this base globe always be visible.', 'interactive-globes' ),
							'dependency' => [ ['enabled', '==', true], ['type', '!=', 'toggle'] ],
							'default' => false,
						],
						'orderInfo'  => [
							'type'    => 'submessage',
							'content' => __( 'The menu order will be the same as the layers order above. You can drag&drop the items to rearrange them.', 'interactive-globes' ),
							'dependency' => [ 'enabled', '==', true ],
							//'style'      => 'info',
						],
					],
				],
			),
		);

		return $meta;
	}
}
