<?php
namespace Saltus\WP\Plugin\Saltus\InteractiveGlobes\Services\Model\Pro;

/**
 * common meta
 */
class MetaColor {
	public static function merge( $meta, $settings ) {

		$assets_url = $settings['assets_url'];

		$meta['globe_info']['sections']['globe']['fields']['globeImage']['options']['earth-hollow'] = sprintf( '%1$s/assets/imgs/earth-hollow.png', $assets_url );
		$meta['globe_info']['sections']['globe']['fields']['globeImage']['options']['noImage'] = sprintf( '%1$s/assets/imgs/earth-noImage.png', $assets_url );
		$meta['globe_info']['sections']['globe']['fields']['globeImage']['options']['customImage'] = sprintf( '%1$s/assets/imgs/earth-customImage.png', $assets_url );
		$meta['globe_info']['sections']['globe']['fields']['globeColor'] = [
			'type'       => 'color',
			'title'      => __( 'Globe Custom Color', 'interactive-globes' ),
			'default'    => '#064273',
			'dependency' => [ [ 'globeImage', '==', 'noImage' ] ],
		];
		$meta['globe_info']['sections']['globe']['fields']['customImage'] = [
			'type'       => 'media',
			'library'    => 'image',
			'desc'       => __( 'Select a custom image to be used in the globe.', 'interactive-globes' ),
			'title'      => __( 'Globe Custom Image', 'interactive-globes' ),
			'dependency' => [ [ 'globeImage', '==', 'customImage' ] ],
		];

		return $meta;
	}
}
