<?php
namespace Saltus\WP\Plugin\Saltus\InteractiveGlobes\Features\Point;

use Saltus\WP\Framework\Infrastructure\Plugin\Registerable;

/**
 * The Point Meta class
 */
class PointProMeta implements Registerable {

	/**
	 * Register Shortcode
	 */
	public function register() {
		add_filter( 'itt_globes/point/model', [ $this, 'add_meta' ] );
	}

	public function add_meta( $point_model ) {

		$options = get_option( 'ittglobes' );

		$actions_default      = apply_filters( 'itt_globes/click_actions', [ 'default' => __('Default', 'interactive-globes') ] );
		$default_colour       = isset( $options['defaultActiveColor'] ) && ! empty( $options['defaultActiveColor'] ) ? $options['defaultActiveColor'] : '#99d8c9';
		$default_hover_colour = isset( $options['defaultHoverColor'] ) && ! empty( $options['defaultHoverColor'] ) ? $options['defaultHoverColor'] : '#2ca25f';

		$point_model['meta']['points_info']['nav']                = 'inline';
		$point_model['meta']['points_info']['sections']['custom'] = [
			'title'  => __( 'Customize', 'interactive-globes' ),
			'icon'   => 'fa fa-cog fa-lg',
			'fields' => array(
				'useCustom' => [
					'type'     => 'switcher',
					'title'    => __( 'Use Custom Options', 'interactive-globes' ),
					'subtitle' => __( 'Define custom colors and actions.', 'interactive-globes' ),
					'default'  => false,
				],
				'action'    => array(
					'type'       => 'select',
					'title'      => __( 'Click Action', 'interactive-globes' ),
					'desc'       => '',
					'options'    => $actions_default,
					'default'    => 'default',
					'dependency' => [ 'useCustom', '==', true ],
				),
				'radius'    => array(
					'type'       => 'spinner',
					'default'    => 20,
					'step'       => 1,
					'title'      => __( 'Radius', 'interactive-globes' ),
					'dependency' => [ 'useCustom', '==', true ],
				),
				'altitude'  => array(
					'type'       => 'spinner',
					'default'    => 1,
					'step'       => 1,
					'title'      => __( 'Altitude', 'interactive-globes' ),
					'dependency' => [ 'useCustom', '==', true ],
				),
				'color'     => array(
					'type'       => 'color',
					'title'      => __( 'Fill Color', 'interactive-globes' ),
					'default'    => $default_colour,
					'dependency' => [ 'useCustom', '==', true ],
				),
				'hover'     => array(
					'type'       => 'color',
					'title'      => __( 'Hover Color', 'interactive-globes' ),
					'default'    => $default_hover_colour,
					'dependency' => [ 'useCustom', '==', true ],
				),
			),
		];
		return $point_model;
	}
}
