# Interactive Globes - 3D World Maps

**Contributors:** carlosmoreirapt, pcarvalho \
**Tags:** map, globe, globes, world, planet earth \
**Requires at least:** 5.0 \
**Tested up to:** 6.6 \
**Requires PHP:** 7.0 \
**Stable tag:** 1.4.1 \
**Donate link:** https://wpinteractiveglobes.com/ \
**License:** GPLv2 or later \
**License URI:** https://www.gnu.org/licenses/gpl-2.0.html
Create realistic, simplified 3D world maps with interactive elements, offering users an engaging, hands-on experience with globe maps.
## Description

Create stunning, interactive 3D world maps globes for your WordPress site.

[Demo](https://wpinteractiveglobes.com/features/) | [Documentation](https://wpinteractiveglobes.com/documentation/) | [Pro](https://wpinteractiveglobes.com/get-pro/)


This plugin offers a realistic 3D world map with clickable map elements, allowing users to explore geographic locations on a dynamic world map in an engaging and immersive way.

Perfect for displaying global data, travel maps, or educational content, this 3D interactive world map plugin enhances user experience with smooth, responsive design.

Easily integrate a customizable 3D world map into your website to captivate your audience.

No API Keys required!

### 3D Globe

The globes are generated using globe.gl, a library that is able to create 3-dimensional globes in a spherical projection, using ThreeJS/WebGL for the 3D rendering.

If you need to display locations a world map, this is the solution for you.

Create your first world map in minutes! Use it to highligh locations, offices, projects, representatives, statistics, or other interactive marker visualization you need!

After you create a globe you'll get a unique shortcode that you can use in all popular page builders, including the block editor, elementor and others.

### Features

- Create as many globe maps as you want
- Responsive and cross-device
- Add round coloured markers
- Set hover color change
- Set click actions, like open a new window
- Choose from different globe images
- Display HTML tooltips on hover

The plugin generates interactive, responsive, touch-enabled map globes which are embeded directly into your HTML5 pages and compatible with all modern browsers and devices.

### Introducing PRO version

- Regions - Colour countries or regions in the globe
- Arc Lines - Add lines connecting two or more points on the globe
- More Globe appearance options: Hollow Globe, Custom Color, Custom Globe Image
- Advanced Click Actions: Display Content Below, Above, Right, Left, in a Lightbox and in an Iframe.
- Priority support
- Priority updates

[Complete List of Features](https://wpinteractiveglobes.com/features/)

## Frequently Asked Questions

### Where can I get coordinates for a marker?

You can get the latitude and longitude needed to a add a marker to a map using sites like [GetLatLong](https://getlatlong.net/) or [LatLong.net](https://www.latlong.net/) or any other similar website.
Clicking the globe preview will also return the coordinates of the clicked point.

### Where can I learn how to use the plugin?

You can visit the [documentation pages on the official website](https://wpinteractiveglobes.com/).

### Do I need an API Key? No

No, the plugin and world maps/globes work without the need of API Keys.


## Screenshots

### 1. World map example 01

[missing image]

### 2. World map example 02

[missing image]

### 3. World map example 03

[missing image]

### 4. Interactive Globes admin screen 01 - Style and settings

[missing image]

### 5. Interactive Globes admin screen 02 - Container settings

[missing image]

### 6. Interactive Globes admin screen 03 - Add Points

[missing image]

### 7. Interactive Globes admin screen 04 - Add Dot Labels

[missing image]


## Changelog

### 1.4.2

- Maintenance: Update globe gl, readme links
- Fix: Use region's name for sorting

### 1.4.1

- Fix: Set bigger lightbox on smaller screens
- Fix: Prevent side color of regions in hollow globe
- Fix: TooltipTemplate and onlyActive for regions tooltips
- Fix: Visual issues when multiple features are enabled
- Fix: Better nl2br handling for html content
- Fix: Update freemius to signal addons
- Deprecate: Deprecate public method: get_globe_items
- Maintenance: Update build tasks, ignores

### 1.4.0

- New: Connect existing markers into new lines
- New: Layers and filters
- New: Dropdown Search
- New: Custom geojson for regions
- New: Quick activation link in admin notice for pro users
- Fix: Pause rotation on hover by default for markers
- Fix: Shortcode footer loading in only plugin's related pages
- Several maintenance and integration fixes

### 1.3.2

- Fix: Update globe render meta filter
- Fix: Add a check on meta for shortcode
- Fix: Update dotlabel meta section name
- New: improved parent globe selection
- New: Tooltips template

### 1.3.1

- New: Copy shortcode button
- Fix: Workaround when API DELETE is blocked
- Fix: Allow assets to be loaded in plugin pages
- Fix: Expose globe parent field when not in iframe [Pro]
- Fix: Improve freemius integration [Pro]
- Fix: Hide some geocoding fields [Pro]

### 1.3.0

- Fix Rest API Error
- Add more filters to help customize the globe rendering
- Better default values
- Ripple effect on click
- Move external Font Awesome files to plugin
- Better action content handling of new lines breaks
- Improved admin preview experience


### 1.2.1

It brings an improved interface.
* add interactions inputs for animation, zoom, pan & rotate
* sets alpha and antialias

### 1.2.0

It introduces a huge work to improve the elements of the globe.
* Rewrite Points and Dotlabels as a cpt
* Add lifecycle events
* Migration from legacy elements to new cpt.
* Add Modal view for elements

### 1.1.1

* Add option to change label
* Reorg globe models

### 1.1.0

* expose Global object ittGlobe
* unify naming

### 1.0.5

* Improve assets loading

### 1.0.4

* Update default radius size
* Fix missing meta
* Prevent loading of assets outside the editor
* Prevent loading meta with shortcode from loading in other screens
* Activate remember tabs
* Separate logic for free/pro
* Separate js features

### 1.0.3

* organize code

### 1.0.2

* update dependencies
* bug fixes

### 1.0.1

* Bug fixing

### 1.0.0

* Initial Release

## Credits

* [globe.gl](https://globe.gl/)
* [Codestar Framework](http://codestarframework.com/)
* [Saltus Framework](https://saltus.dev)
