<?php
namespace Saltus\WP\Plugin\InteractiveGlobes\Services\Model\Pro;

/**
 * Manage Assets like scripts and styles.
 */
class Options {

	public static function get( $settings ) {
		$capability = isset( $settings['capability'] ) ? $settings['capability'] : null;
		$options = get_option( 'ittglobes' );

		$public = isset( $options['single_pages'] ) && isset( $options['single_pages']['enabled'] ) ? $options['single_pages']['enabled'] : false;

		$options = [
			'public'             => false,
			'publicly_queryable' => true,
			'show_in_rest'       => true,
			'show_ui'            => true,
			'show_in_menu'       => true,
			'query_var'          => true,
			'has_archive'        => false,
			'hierarchical'       => false,
			'menu_position'      => null,
			'can_export'         => true,
			'capability_type'    => $capability,
			'menu_icon'          => 'dashicons-admin-site-alt',
			'rewrite'            => [
				'slug'       => 'globe',
				'with_front' => true,
				'feeds'      => true,
				'pages'      => true,
			],
		];

		if ( $public ) {
			$options['public']             = true;
			$options['publicly_queryable'] = true;
			$options['query_var']          = true;
			$options['rewrite']            = [
				'slug' => ! empty( $options['single_pages']['slug'] ) ? $options['single_pages']['slug'] : 'globe',
			];
		}
		return $options;
	}
}
