<?php
namespace Saltus\WP\Plugin\InteractiveGlobes\Services\Model\Pro;

/**
 * common meta
 */
class MetaSearch {
	public static function merge( $meta ) {

		// PRO tooltip meta
		$meta['globe_info']['sections']['search'] = array(
			'title'  => __( 'External Controls', 'interactive-globes' ),
			'icon'   => 'fa fa-search fa-lg',
			'class'  => 'search_tab',
			'fields' => array(
				'search' => [
					'type'   => 'fieldset',
					'fields' => [
						'search_fieldset_title' => [
							'type'    => 'subheading',
							'content' => __( 'Autocomplete Search Dropdown', 'interactive-globes' ),
						],
						'enabled' => [
							'type'    => 'switcher',
							'title'   => __( 'Enable Search Dropdown', 'interactive-globes' ),
							'default' => false,
						],
						'position' => [
							'type'    => 'select',
							'title'   => __( 'Position', 'interactive-globes' ),
							'options' => [
								'before'    => __( 'Top', 'interactive-globes' ),
								'after' => __( 'Bottom', 'interactive-globes' ),
							],
							'default' => 'top',
							'dependency' => [ [ 'enabled', '==', true ] ],
						],
						'mobile_only' => [
							'type'    => 'switcher',
							'title'   => __( 'Mobile Only', 'interactive-globes' ),
							'default' => false,
							'dependency' => [ [ 'enabled', '==', true ] ],
						],
						'choices' => [
							'type'    => 'switcher',
							'title'   => __( 'Use Choices.js', 'interactive-globes' ),
							'desc'    => __( 'Use Choices.js for the search dropdown. This will allow you to use a custom search input and dropdown styling. <br>When disabled the it will display a simple select dropdown with no search.', 'interactive-globes' ),
							'default' => true,
							'dependency' => [ [ 'enabled', '==', true ] ],
						],
						'placeholder_text' => [
							'type'    => 'text',
							'title'   => __( 'Placeholder Text', 'interactive-globes' ),
							'default' => __( 'Search...', 'interactive-globes' ),
							'dependency' => [ [ 'enabled', '==', true ] ],
						],
						'no_matches_text' => [
							'type'    => 'text',
							'title'   => __( 'No Matches Text', 'interactive-globes' ),
							'default' => __( 'No matches found', 'interactive-globes' ),
							'dependency' => [ [ 'enabled', '==', true ], [ 'choices', '==', true ] ],
						],
						'select_text' => [
							'type'    => 'text',
							'title'   => __( 'Select Text', 'interactive-globes' ),
							'default' => __( 'Select', 'interactive-globes' ),
							'dependency' => [ [ 'enabled', '==', true ], [ 'choices', '==', true ] ],
						],
						'label_property' => [
							'type'    => 'text',
							'title'   => __( 'Label Property', 'interactive-globes' ),
							'desc'    => __( 'The property of the data object to use as the label for the search dropdown. Default: "title"', 'interactive-globes' ),
							'default' => 'title',
							'dependency' => [ [ 'enabled', '==', true ], [ 'choices', '==', true ] ],
						],
						'properties' => [
							'type'    => 'text',
							'title'   => __( 'Properties to search', 'interactive-globes' ),
							'desc'    => __( 'The properties of the data object to include in search for in the search dropdown. It will search for the label property by default already. You can add multiple properties by separating them with a comma.', 'interactive-globes' ),
							'default' => '',
							'dependency' => [ [ 'enabled', '==', true ], [ 'choices', '==', true ] ],
						],
					],
				],
			),
		);

		return $meta;
	}
}
