<?php
namespace Saltus\WP\Plugin\InteractiveGlobes\Services\Model\Pro;

/**
 * Point meta
 */
class MetaPoint {
	public static function merge( $meta, $settings ) {

		$options         = $settings['options'];
		$template_editor = isset( $options['template_editor'] ) ? $options['template_editor'] : 'text';


		$meta['globe_info']['sections']['points']['fields']['pointDefaults']['fields']['type'] = [
			'type'    => 'button_set',
			'title'   => __( 'Type', 'interactive-globes' ),
			'desc'    => __( 'Choose the type of 3D marker.', 'interactive-globes' ),
			'options' => [
				'cylinder' => '<i class="fas fa-circle"></i> ' . __( 'Cylinder (default)', 'interactive-globes' ),
				'pin' => '<i class="fas fa-map-pin"></i> ' . __( 'Pin', 'interactive-globes' ),
				'marker' => '<i class="fas fa-map-marker-alt"></i> ' . __( 'Marker', 'interactive-globes' ),
				'image' => '<i class="fas fa-image"></i> ' . __( 'Image', 'interactive-globes' ),
				'flag' => '<i class="fas fa-flag"></i> ' . __( 'Flag', 'interactive-globes' ),
			],
			'default' => 'cylinder',
		];

		$meta['globe_info']['sections']['points']['fields']['pointDefaults']['fields']['image'] = [
			'type'       => 'media',
			'library'    => 'image',
			'title'      => __( 'Image', 'interactive-globes' ),
			'desc'       => __( 'Image to use for this marker type.', 'interactive-globes' ),
			'dependency' => [ 'type', 'any', 'image,flag' ],
		];

		$meta['globe_info']['sections']['points']['fields']['pointDefaults']['fields']['animate'] = [
			'type'       => 'switcher',
			'title'      => __( 'Animate', 'interactive-globes' ),
			'desc'       => __( 'Animate the marker. ', 'interactive-globes' ),
			'dependency' => [ 'type', 'any', 'flag,marker,image' ],
		];

		$meta['globe_info']['sections']['points']['fields']['pointDefaults']['fields']['imageOrientation'] = [
			'type'       => 'select',
			'title'      => __( 'Image Orientation', 'interactive-globes' ),
			'options'    => [
				'horizontal' => __( 'Horizontal', 'interactive-globes' ),
				'vertical'   => __( 'Vertical', 'interactive-globes' ),
			],
			'default'    => 'horizontal',
			'dependency' => [ [ 'type', '==', 'image' ] ],
		];

		$meta['globe_info']['sections']['points']['fields']['pointDefaults']['fields']['color']['dependency'][] = [
			'type', '!=', 'image'
		];
		$meta['globe_info']['sections']['points']['fields']['pointDefaults']['fields']['hover']['dependency'][] = [
			'type', '!=', 'image'
		];
		$meta['globe_info']['sections']['points']['fields']['pointDefaults']['fields']['hover']['dependency'][] = [
			'type', '!=', 'flag'
		];

		$meta['globe_info']['sections']['points']['fields']['pointsTooltipTemplate'] = [
			'type'    => $template_editor,
			'title'   => __( 'Tooltip Template', 'interactive-globes' ),
			'default' => '',
			'desc'    => __( 'Override default tooltip template. You can use placeholders with curly brackets like {title} that exist in your data source.<br>Default value is {tooltipContent}.', 'interactive-globes' ),
		];
		return $meta;
	}
}
