<?php
namespace Saltus\WP\Plugin\InteractiveGlobes\Services\Model\Pro;

use Saltus\WP\Plugin\InteractiveGlobes\Features\Meta\MetaCore;
/**
 * common meta
 */
class MetaLines {
	public static function merge( $meta, $settings ) {

		$options          = $settings['options'];
		$default_colour   = isset( $options['defaultActiveColor'] ) && ! empty( $options['defaultActiveColor'] ) ? $options['defaultActiveColor'] : '#99d8c9';
		$current_globe_id = isset($_GET['post']) ? intval($_GET['post']) : 0;

		// PRO lines meta
		$meta['globe_info']['sections']['arcLines'] = array(
			'title'  => __( 'Arc Lines', 'interactive-globes' ),
			'icon'   => 'fa fa-circle-notch fa-lg fa-rotate-180',
			'fields' => array(
				'arcLines_cpt' => array(
					'type'     => 'callback',
					'function' => [ MetaCore::class, 'cpt_manager' ],
					'args'     => [
						'cpt'          => 'itt_globe_line',
						'button_label' => __( 'Add New Line', 'interactive-globes' ),
					],
				),
				'arcLineDefaults' => [
					'type'   => 'fieldset',
					'title'  => __( 'Defaults', 'interactive-globes' ),
					'fields' => [
						'stroke'      => [
							'type'    => 'color',
							'title'   => __( 'Arc Line Color', 'interactive-globes' ),
							'default' => $default_colour,
						],
						'dashLength'  => [
							'type'       => 'spinner',
							'default'    => 100,
							'max'        => 100,
							'min'        => 0,
							'step'       => 1,
							'attributes' => [
								'step' => 'any',
							],
							'title'      => __( 'Line Dash', 'interactive-globes' ),
							'desc'       => __( 'The length of the dashed segments in the arc, in terms of relative line length. (100 = full relative line length)', 'interactive-globes' ),
						],
						'dashGap'  => [
							'type'       => 'spinner',
							'default'    => 100,
							'max'        => 100,
							'min'        => 0,
							'step'       => 1,
							'attributes' => [
								'step' => 'any',
							],
							'title'      => __( 'Line Dash Gap', 'interactive-globes' ),
							'desc'       => __( 'The length of the gap between dash segments, in terms of relative line length. ( 0 = no gap, 0.1 = minimum gap, 100 = full relative line lenght )', 'interactive-globes' ),
						],
						'strokeWidth' => [
							'type'    => 'spinner',
							'default' => 2,
							'title'   => __( 'Line Width', 'interactive-globes' ),
							'desc'    => __( 'The line’s diameter, in angular degrees', 'interactive-globes' ),
						],
						'altitude'    => [
							'type'       => 'spinner',
							'default'    => 10,
							'max'        => 100,
							'min'        => 0,
							'step'       => 1,
							'attributes' => [
								'step' => 'any',
							],
							'title'      => __( 'Altitude', 'interactive-globes' ),
							'desc'       => __( 'The arc’s maximum altitude, ocurring at the half-way distance between the two points. ( 0 = ground line, 100 = globe radius )', 'interactive-globes' ),
						],
						'animate'     => [
							'type'       => 'spinner',
							'default'    => 0,
							'desc'       => __( 'Time duration (in seconds) to animate the motion of dash positions from the start to the end Region for a full line length. A value of 0 disables the animation. Make sure the Dash Lenght is less than 100 to visualize the animation.', 'interactive-globes' ),
							'min'        => 0,
							'step'       => 1,
							'attributes' => [
								'step' => 'any',
							],
							'title'      => __( 'Animation speed', 'interactive-globes' ),
						],
					],
				],
				'autoLines' => [
					'type' => 'fieldset',
					'title' => __( 'Connect Points', 'interactive-globes' ),
					'subtitle' => __( 'Connect points or dot labels to a specific point or dot label', 'interactive-globes' ),
					'fields' => [
						'enabled' => [
							'type' => 'switcher',
							'default' => false,
							'title' => __( 'Enabled', 'interactive-globes' ),
						],
						'rules' => [
							'type' => 'group',
							'title' => __( 'Connection Rules', 'interactive-globes' ),
							'fields' => [
								'rule' => [
									'type' => 'select',
									'title' => __( 'Connection Rule', 'interactive-globes' ),
									'options' => [
										'connect_points' => __( 'Connect all points to/from', 'interactive-globes' ),
										'connect_dotlabels' => __( 'Connect all dotLabels to/from', 'interactive-globes' ),
									],
									'default' => 'connect_points',
								],
								'connection_type' => [
									'type' => 'button_set',
									'title' => __( 'Connection Type', 'interactive-globes' ),
									'options' => [
										'source' => __( 'Source', 'interactive-globes' ),
										'destination' => __( 'Destination', 'interactive-globes' ),
									],
									'default' => 'destination',
								],
								'point' => [
									'type' => 'select',
									'title' => __( 'Target Point', 'interactive-globes' ),
									'desc' => __( 'Select the point to connect to/from. Currently only points created manually are supported.', 'interactive-globes' ),
									'options' => 'posts',
									'query_args' => [
										'post_type' => 'itt_globe_point',
										'posts_per_page' => -1,
										'meta_query' => [
											[
												'key' => 'globe_id',
												'value' => $current_globe_id,
												'compare' => '=',
											],
										],
									],
									'dependency' => [ 'rule', '==', 'connect_points' ],
								],
								'dotLabel' => [
									'type' => 'select',
									'title' => __( 'Target Dot Label', 'interactive-globes' ),
									'options' => 'posts',
									'query_args' => [
										'post_type' => 'itt_globe_dotlabel',
										'posts_per_page' => -1,
										'meta_query' => [
											[
												'key' => 'globe_id',
												'value' => $current_globe_id,
												'compare' => '=',
											],
										],
									],
									'dependency' => [ 'rule', '==', 'connect_dotlabels' ],
								],
							],
							'dependency' => [ 'enabled', '==', true ],
						],
					],
				]
			),
		);

		return $meta;
	}
}
