<?php
namespace Saltus\WP\Plugin\InteractiveGlobes\Services\Model\Pro;

use Saltus\WP\Plugin\InteractiveGlobes\Features\Meta\MetaCore;

/**
 * HTML marker meta
 */
class MetaHTML {
	public static function merge( $meta, $settings ) {

		$options         = $settings['options'];
		$template_editor = isset( $options['template_editor'] ) ? $options['template_editor'] : 'text';

		$actions_default = $settings['actions_default'];

		$meta['globe_info']['sections']['html_markers'] = [
			'title'  => __( 'HTML Markers', 'interactive-globes' ),
			'icon'   => 'fa fa-code fa-lg',
			'class'  => 'html_tab',
			'fields' => array(
				'htmlInfo'   => array(
					'type'    => 'content',
					'content' => '<div class="ig_admin_example"><div>' . __( 'Add HTML Markers to your globe.', 'interactive-globes' ).'</div></div>',
				),
				'html_cpt' => array(
					'type'     => 'callback',
					'function' => [ MetaCore::class, 'cpt_manager' ],
					'args'     => [
						'cpt'          => 'itt_globe_html',
						'data'         => [ 'latitude', 'longitude' ],
						'button_label' => __( 'Add New HTML Marker', 'interactive-globes' ),
					],
				),
				'htmlDefaults' => array(
					'type'   => 'fieldset',
					'title'  => __( 'Default values', 'interactive-globes' ),
					'desc'   => '',
					'fields' => array(

						'htmlTemplate' => array(
							'type'  => 'textarea',
							'title' => __( 'HTML Marker Template', 'interactive-globes' ),
							'desc'  => __( 'Template for the HTML content. You can use HTML code and if necessary use the <code>{title}</code> or <code>{content}</code> variable to insert the content of the entry.', 'interactive-globes' ),
							'default' => '<div class="itt_globe_html_marker">{title}</div>',
						),

						'action'   => array(
							'type'    => 'select',
							'title'   => __( 'Click Action', 'interactive-globes' ),
							'desc'    => '',
							'options' => $actions_default,
							'default' => 'none',
						),
					),
				),

			),
		];

		return $meta;
	}
}
