<?php
namespace Saltus\WP\Plugin\InteractiveGlobes\Services\Model\Pro;

use Saltus\WP\Plugin\InteractiveGlobes\Features\ClickActions\ClickActionOption;
use Saltus\WP\Plugin\InteractiveGlobes\Features\ClickActions\DisplayContentAbove;
use Saltus\WP\Plugin\InteractiveGlobes\Features\ClickActions\DisplayContentBelow;
use Saltus\WP\Plugin\InteractiveGlobes\Features\ClickActions\DisplayContentBelowScroll;
use Saltus\WP\Plugin\InteractiveGlobes\Features\ClickActions\DisplayContentLeft;
use Saltus\WP\Plugin\InteractiveGlobes\Features\ClickActions\DisplayContentRight;
use Saltus\WP\Plugin\InteractiveGlobes\Features\ClickActions\DisplayContentLightbox;
use Saltus\WP\Plugin\InteractiveGlobes\Features\ClickActions\DisplayIframeLightbox;

/**
 * Dot label meta
 */
class ClickActions {
	public static function merge( $click_actions ) {
		$click_pro_actions = [
			'DisplayContentBelow'       => new DisplayContentBelow(),
			'DisplayContentBelowScroll' => new DisplayContentBelowScroll(),
			'DisplayContentAbove'       => new DisplayContentAbove(),
			'DisplayContentRight'       => new DisplayContentRight(),
			'DisplayContentLeft'        => new DisplayContentLeft(),
			'DisplayContentLightbox'    => new DisplayContentLightbox(),
			'DisplayIframeLightbox'     => new DisplayIframeLightbox(),
		];
		foreach ( $click_pro_actions as $key => $click_action ) {

			if ( $click_action instanceof ClickActionOption ) {
				$click_actions[ $key ] = $click_action->get_option();
			}
		}

		// add filter
		add_filter( 'itt_globes/click_actions', function ( $existing_actions ) use ( $click_actions ) {
			return array_merge( $existing_actions, $click_actions );
		} );

		return $click_actions;
	}
}
