<?php
namespace Saltus\WP\Plugin\InteractiveGlobes\Features\ClickActions;

if ( defined( 'SALTUS_PLAN' ) && SALTUS_PLAN !== 'pro' ) {
	return [];
}
use Saltus\WP\Plugin\InteractiveGlobes\Saltus\WP\Framework\Infrastructure\Plugin\Registerable;

class DisplayContentBelow implements ClickActionOption, Registerable {

	private $position;
	private $option_label;
	private $content_filter;

	public function __construct() {

		$this->position = 'below';

		switch ( $this->position ) {
			case 'below':
				$this->option_label = __( 'Display content below', 'interactive-globes' );
				$this->content_filter = 'itt_globes/render/content_after';
				break;

			case 'belowScroll':
				$this->option_label = __( 'Display content below & scroll', 'interactive-globes' );
				$this->content_filter = 'itt_globes/render/content_after';
				break;

			case 'above':
				$this->option_label = __( 'Display content above', 'interactive-globes' );
				$this->content_filter = 'itt_globes/render/content_before';
				break;

			case 'right':
				$this->option_label = __( 'Display content right', 'interactive-globes' );
				$this->content_filter = 'itt_globes/render/content_after';
				break;

			case 'left':
				$this->option_label = __( 'Display content left', 'interactive-globes' );
				$this->content_filter = 'itt_globes/render/content_before';
				break;

			default:
				$this->option_label = __( 'Display content', 'interactive-globes' );
				$this->content_filter = 'itt_globes/render/content_after';
				break;
		}
	}

	/**
	 * Register HTML for Action
	 */
	public function register() {

		// add globe container class
		add_filter(
			'itt_globes/render/container_class',
			function ( $container_class, $id ) {
				$container_class .= ' itt_globe_display_content_' . $this->position;
				return $container_class;
			},
			2,
			2
		);

		// add container div
		add_filter(
			$this->content_filter,
			function ( $content, $id ) {

				$default = ''; // no default for now

				$id_sufix = $this->position;

				$html = sprintf(
					'<div class="itt_globe_content itt_globe_content_%2$s" id="itt_globe_content_%2$s_%1$s"> %3$s </div>',
					$id,
					$id_sufix,
					$default
				);
				if ( $content !== $html ) {
					$content = $html . $content;
				}
				return $content;
			},
			1, // we set it to low priority to be added at straight away, so it ends up after the content right container
			2
		);
	}

	public function get_option() {
		return $this->option_label;
	}
}
