# Interactive Globes - 3D World Maps

**Contributors:** carlosmoreirapt, pcarvalho \
**Tags:** map, globe, globes, world, planet earth \
**Requires at least:** 5.0 \
**Tested up to:** 6.7 \
**Requires PHP:** 7.0 \
**Stable tag:** 1.4.3 \
**Donate link:** https://wpinteractiveglobes.com/ \
**License:** GPLv2 or later \
**License URI:** https://www.gnu.org/licenses/gpl-2.0.html
Create realistic, simplified 3D world maps with interactive elements, offering users an engaging, hands-on experience with globe maps.
## Description

Create stunning, interactive 3D world maps globes for your WordPress site.

[Demo](https://wpinteractiveglobes.com/features/) | [Documentation](https://wpinteractiveglobes.com/documentation/) | [Pro](https://wpinteractiveglobes.com/get-pro/)


This plugin offers a realistic 3D world map with clickable map elements, allowing users to explore geographic locations on a dynamic world map in an engaging and immersive way.

Perfect for displaying global data, travel maps, or educational content, this 3D interactive world map plugin enhances user experience with smooth, responsive design.

Easily integrate a customizable 3D world map into your website to captivate your audience.

No API Keys required!

### 3D Globe

The globes are generated using globe.gl, a library that is able to create 3-dimensional globes in a spherical projection, using ThreeJS/WebGL for the 3D rendering.

If you need to display locations on a world map, this is the solution for you. There are different world map representations, night and day, you can choose from different globe images.

Create your first 3D interactive world map in minutes! Use this powerful 3D map WordPress plugin to highlight locations, offices, projects, representatives, statistics, or any interactive marker visualizations you need, such as visited cities map, etc!

After you create a globe you'll get a unique shortcode that you can use in all popular page builders, including the block editor, elementor and others.

### Free Features

- Create as many globe maps as you want
- Responsive and cross-device
- Add coloured markers and dot text labels
- Set hover color change
- Set click actions, like open a new window
- Choose from different globe images
- Display HTML tooltips on hover

The plugin generates interactive, responsive, touch-enabled map globes which are embedded directly into your HTML5 pages and compatible with all modern browsers and devices.

### PRO version Features

- Regions - Colour countries or regions in the globe - great for visited countries map
- Arc Lines - Add lines connecting two or more points on the globe
- More Globe appearance options: Hollow Globe, Custom Color, Custom Globe Image
- More marker types: custom images, html markers, 3d pins
- Advanced Click Actions: Display Content Below, Above, Right, Left, in a Lightbox and in an Iframe.
- Priority support
- Priority updates

[Complete List of Features](https://wpinteractiveglobes.com/features/)

## Frequently Asked Questions

### Where can I get coordinates for a marker?

You can get the latitude and longitude needed to a add a marker to a map using sites like [GetLatLong](https://getlatlong.net/) or [LatLong.net](https://www.latlong.net/) or any other similar website.
Clicking the globe preview will also return the coordinates of the clicked point.

### Where can I learn how to use the plugin?

You can visit the [documentation pages on the official website](https://wpinteractiveglobes.com/).

### Do I need an API Key? No

No, the plugin and world maps/globes work without the need of API Keys.


## Screenshots

### 1. World map example 01

![World map example 01](https://ps.w.org/interactive-globes/assets/screenshot-1.png)

### 2. World map example 02

![World map example 02](https://ps.w.org/interactive-globes/assets/screenshot-2.png)

### 3. World map example 03

![World map example 03](https://ps.w.org/interactive-globes/assets/screenshot-3.png)

### 4. Interactive Globes admin screen 01 - Style and settings

![Interactive Globes admin screen 01 - Style and settings](https://ps.w.org/interactive-globes/assets/screenshot-4.png)

### 5. Interactive Globes admin screen 02 - Container settings

![Interactive Globes admin screen 02 - Container settings](https://ps.w.org/interactive-globes/assets/screenshot-5.png)

### 6. Interactive Globes admin screen 03 - Add Points

![Interactive Globes admin screen 03 - Add Points](https://ps.w.org/interactive-globes/assets/screenshot-6.png)

### 7. Interactive Globes admin screen 04 - Add Dot Labels

![Interactive Globes admin screen 04 - Add Dot Labels](https://ps.w.org/interactive-globes/assets/screenshot-7.png)


## Changelog

### 1.4.6

- New: Add modal styles
- New: Set Maximum Allowed Zoom
- New: Add percentage placeholder in Region Counter
- Fix: Flag pole is not rendering altitude correctly
- Fix: Change wording in altitude field description
- Fix: Selecting WP Rich Text editor for any field in the settings causes PHP error
- Fix: HTML Markers are showing up in Free version
- Fix: Only include active regions in Region Counter
- Fix: Streamline the dimensions of Click Action areas
- Maintenance: Improve vendor prefix


### 1.4.5

- New: HTML marker
- New: 3D pins: Pin, Flag, Image and Marker
- New: Region Counter
- Fix: Trigger actions in modal
- Fix: Improve modal styles
- Fix: Click actions array
- Fix: Add click actions to point
- Fix: Ignore globe id 0 when hooking meta data
- Maintenance: Update readme
- Maintenance: Simplify namespace and add prefix to vendors


### 1.4.4

- New: Double tap/click zooms in
- New: Region stroke color
- Fix: Button styles in modal
- Fix: Prevent globe library to load where is not needed
- Fix: Prevent loading multiple instances of Three.js
- Fix: clean up code

### 1.4.3

- New: Duplicate/clone globe
- Fix: Allow word delimiters in rest api point
- Fix: Region json field when missing files
- Fix: Region list
- Fix: Action clicks
- Fix: Empty dot label name
- Fix: Redirect on license activation
- Fix: Loading model order
- Fix: Copy shortcode to clipboard with old method


### 1.4.2

- Maintenance: Update globe gl, readme links
- Fix: Use region's name for sorting

### 1.4.1

- Fix: Set bigger lightbox on smaller screens
- Fix: Prevent side color of regions in hollow globe
- Fix: TooltipTemplate and onlyActive for regions tooltips
- Fix: Visual issues when multiple features are enabled
- Fix: Better nl2br handling for html content
- Fix: Update freemius to signal addons
- Deprecate: Deprecate public method: get_globe_items
- Maintenance: Update build tasks, ignores

### 1.4.0

- New: Connect existing markers into new lines
- New: Layers and filters
- New: Dropdown Search
- New: Custom geojson for regions
- New: Quick activation link in admin notice for pro users
- Fix: Pause rotation on hover by default for markers
- Fix: Shortcode footer loading in only plugin's related pages
- Several maintenance and integration fixes

### 1.3.2

- Fix: Update globe render meta filter
- Fix: Add a check on meta for shortcode
- Fix: Update dotlabel meta section name
- New: improved parent globe selection
- New: Tooltips template

### 1.3.1

- New: Copy shortcode button
- Fix: Workaround when API DELETE is blocked
- Fix: Allow assets to be loaded in plugin pages
- Fix: Expose globe parent field when not in iframe [Pro]
- Fix: Improve freemius integration [Pro]
- Fix: Hide some geocoding fields [Pro]

### 1.3.0

- Fix Rest API Error
- Add more filters to help customize the globe rendering
- Better default values
- Ripple effect on click
- Move external Font Awesome files to plugin
- Better action content handling of new lines breaks
- Improved admin preview experience


### 1.2.1

It brings an improved interface.
* add interactions inputs for animation, zoom, pan & rotate
* sets alpha and antialias

### 1.2.0

It introduces a huge work to improve the elements of the globe.
* Rewrite Points and Dotlabels as a cpt
* Add lifecycle events
* Migration from legacy elements to new cpt.
* Add Modal view for elements

### 1.1.1

* Add option to change label
* Reorg globe models

### 1.1.0

* expose Global object ittGlobe
* unify naming

### 1.0.5

* Improve assets loading

### 1.0.4

* Update default radius size
* Fix missing meta
* Prevent loading of assets outside the editor
* Prevent loading meta with shortcode from loading in other screens
* Activate remember tabs
* Separate logic for free/pro
* Separate js features

### 1.0.3

* organize code

### 1.0.2

* update dependencies
* bug fixes

### 1.0.1

* Bug fixing

### 1.0.0

* Initial Release

## Credits

* [globe.gl](https://globe.gl/)
* [Codestar Framework](http://codestarframework.com/)
* [Saltus Framework](https://saltus.dev)
